@extends('layouts.app')

@section('content')
<!-- Main content -->
<section class="content no-print">

    <style>
      #purchase_table { width: 100% !important; }
      #purchase_table th, #purchase_table td { vertical-align: middle !important; }
      .dataTables_scrollHeadInner, .dataTables_scrollHeadInner table { width: 100% !important; }
    </style>

    {{-- Remove Pay Due Amount + Add Discount globally (instant, no flicker) --}}
    <style>
      a.pay_purchase_due,
      .pay_purchase_due,
      #add_discount,
      #add_ledger_discount,
      #add_ledger_discount_btn,
      .btn-add-discount,
      .contact-add-discount,
      .tw-add-discount {
        display: none !important;
        visibility: hidden !important;
      }
    </style>

    <div class="hide print_table_part">
        <style type="text/css">
            .info_col { width:25%; float:left; padding-left:10px; padding-right:10px; }
        </style>
        <div style="width:100%;">
            <div class="info_col">@include('contact.contact_basic_info')</div>
            <div class="info_col">@include('contact.contact_more_info')</div>
            @if($contact->type != 'customer')
                <div class="info_col">@include('contact.contact_tax_info')</div>
            @endif
            <div class="info_col">@include('contact.contact_payment_info')</div>
        </div>
    </div>

    <input type="hidden" id="sell_list_filter_customer_id" value="{{$contact->id}}">
    <input type="hidden" id="purchase_list_filter_supplier_id" value="{{$contact->id}}">
    <br>

    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-body">
                    @include('contact.partials.contact_info_tab')
                </div>
            </div>
        </div>
    </div>

    <div class="row"><div class="col-md-12">
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs nav-justified">
                <li class="@if(!empty($view_type) && $view_type == 'ledger') active @else '' @endif">
                    <a href="#ledger_tab" data-toggle="tab"><i class="fas fa-scroll"></i> @lang('lang_v1.ledger')</a>
                </li>

                @if(in_array($contact->type, ['both','supplier']))
                    <li class="@if(!empty($view_type) && $view_type == 'purchase') active @else '' @endif">
                        <a href="#purchases_tab" data-toggle="tab"><i class="fas fa-arrow-circle-down"></i> @lang('purchase.purchases')</a>
                    </li>
                    <li class="@if(!empty($view_type) && $view_type == 'stock_report') active @else '' @endif">
                        <a href="#stock_report_tab" data-toggle="tab"><i class="fas fa-hourglass-half"></i> @lang('report.stock_report')</a>
                    </li>
                @endif

                @if(in_array($contact->type, ['both','customer']))
                    <li class="@if(!empty($view_type) && $view_type == 'sales') active @else '' @endif">
                        <a href="#sales_tab" data-toggle="tab"><i class="fas fa-arrow-circle-up"></i> @lang('sale.sells')</a>
                    </li>
                    @if(in_array('subscription', $enabled_modules))
                        <li class="@if(!empty($view_type) && $view_type == 'subscriptions') active @else '' @endif">
                            <a href="#subscriptions_tab" data-toggle="tab"><i class="fas fa-recycle"></i> @lang('lang_v1.subscriptions')</a>
                        </li>
                    @endif
                @endif

                <li class="@if(!empty($view_type) && $view_type == 'documents_and_notes') active @else '' @endif">
                    <a href="#documents_and_notes_tab" data-toggle="tab"><i class="fas fa-paperclip"></i> @lang('lang_v1.documents_and_notes')</a>
                </li>
                <li class="@if(!empty($view_type) && $view_type == 'payments') active @else '' @endif">
                    <a href="#payments_tab" data-toggle="tab"><i class="fas fa-money-bill-alt"></i> @lang('sale.payments')</a>
                </li>

                @if(in_array($contact->type, ['customer','both']) && session('business.enable_rp'))
                    <li class="@if(!empty($view_type) && $view_type == 'reward_point') active @else '' @endif">
                        <a href="#reward_point_tab" data-toggle="tab"><i class="fas fa-gift"></i> {{ session('business.rp_name') ?? __('lang_v1.reward_points') }}</a>
                    </li>
                @endif

                <li class="@if(!empty($view_type) && $view_type == 'activities') active @else '' @endif">
                    <a href="#activities_tab" data-toggle="tab"><i class="fas fa-pen-square"></i> @lang('lang_v1.activities')</a>
                </li>

                @if(!empty($contact_view_tabs))
                    @foreach($contact_view_tabs as $tabs)
                        @foreach ($tabs as $value)
                            @if(!empty($value['tab_menu_path']))
                                @php $tab_data = $value['tab_data'] ?? []; @endphp
                                @include($value['tab_menu_path'], $tab_data)
                            @endif
                        @endforeach
                    @endforeach
                @endif
            </ul>

            <div class="tab-content">
                {{-- LEDGER --}}
                <div class="tab-pane @if(!empty($view_type) && $view_type == 'ledger') active @else '' @endif" id="ledger_tab">
                    @include('contact.partials.ledger_tab')
                </div>

                @if(in_array($contact->type, ['both','supplier']))
                    {{-- PURCHASES --}}
                    <div class="tab-pane @if(!empty($view_type) && $view_type == 'purchase') active @else '' @endif" id="purchases_tab">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('purchase_list_filter_date_range', __('report.date_range') . ':') !!}
                                    {!! Form::text('purchase_list_filter_date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly']) !!}
                                </div>
                            </div>
                            {{-- Purchase Mode (kept for Purchases tab only) --}}
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('purchase_mode_filter', __('Mode') . ':') !!}
                                    {!! Form::select('purchase_mode_filter', ['cash' => __('lang_v1.cash'),'consignment' => __('Consignment'),'terms' => __('Terms')], null, ['class'=>'form-control select2','style'=>'width:100%','id'=>'purchase_mode_filter','placeholder'=>__('lang_v1.all')]) !!}
                                </div>
                            </div>

                            <div class="col-md-12">@include('purchase.partials.purchase_table')</div>
                        </div>
                    </div>

                    {{-- STOCK REPORT --}}
                    <div class="tab-pane @if(!empty($view_type) && $view_type == 'stock_report') active @else '' @endif" id="stock_report_tab">
                        {{-- No date filter here. We rely on the Business Location inside the partial only. --}}
                        @include('contact.partials.stock_report_tab')
                    </div>
                @endif

                @if(in_array($contact->type, ['both','customer']))
                    {{-- SALES --}}
                    <div class="tab-pane @if(!empty($view_type) && $view_type == 'sales') active @else '' @endif" id="sales_tab">
                        <div class="row">
                            <div class="col-md-12">
                                @component('components.widget')
                                    @include('sell.partials.sell_list_filters', ['only' => ['sell_list_filter_payment_status','sell_list_filter_date_range','only_subscriptions']])
                                @endcomponent
                            </div>
                        </div>
                        <div class="row"><div class="col-md-12">@include('sale_pos.partials.sales_table')</div></div>
                    </div>

                    @if(in_array('subscription', $enabled_modules))
                        @include('contact.partials.subscriptions')
                    @endif
                @endif

                {{-- DOCS & NOTE --}}
                <div class="tab-pane @if(!empty($view_type) && $view_type == 'documents_and_notes') active @else '' @endif" id="documents_and_notes_tab">
                    @include('contact.partials.documents_and_notes_tab')
                </div>

                {{-- PAYMENTS --}}
                <div class="tab-pane @if(!empty($view_type) && $view_type == 'payments') active @else '' @endif" id="payments_tab">
                    <div id="contact_payments_div" style="height:500px; overflow-y:scroll;"></div>
                </div>

                {{-- REWARD POINTS --}}
                @if(in_array($contact->type, ['customer','both']) && session('business.enable_rp'))
                    <div class="tab-pane @if(!empty($view_type) && $view_type == 'reward_point') active @else '' @endif" id="reward_point_tab">
                        <br>
                        <div class="row">
                            @if($reward_enabled)
                                <div class="col-md-3">
                                    <div class="info-box bg-yellow">
                                        <span class="info-box-icon"><i class="fa fa-gift"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">{{ session('business.rp_name') }}</span>
                                            <span class="info-box-number">{{ $contact->total_rp ?? 0 }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="rp_log_table" width="100%">
                                        <thead>
                                            <tr>
                                                <th>@lang('messages.date')</th>
                                                <th>@lang('sale.invoice_no')</th>
                                                <th>@lang('lang_v1.earned')</th>
                                                <th>@lang('lang_v1.redeemed')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- ACTIVITIES --}}
                <div class="tab-pane" id="activities_tab">@include('activity_log.activities')</div>

                {{-- EXTRA MODULE TAB CONTENT --}}
                @if(!empty($contact_view_tabs))
                    @foreach($contact_view_tabs as $tabs)
                        @foreach ($tabs as $value)
                            @if(!empty($value['tab_content_path']))
                                @php $tab_data = $value['tab_data'] ?? []; @endphp
                                @include($value['tab_content_path'], $tab_data)
                            @endif
                        @endforeach
                    @endforeach
                @endif
            </div>
        </div>
    </div></div>
</section>

<!-- Modals -->
<div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
<div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
<div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
<div class="modal fade" id="edit_ledger_discount_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

<!-- Modal shell used by AJAX-loaded views -->
<div class="modal fade view_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

<style>
    .customer-qr-card {
        background: linear-gradient(135deg, rgba(11, 94, 145, 0.12), rgba(38, 198, 255, 0.06));
        border-radius: 18px;
        padding: 22px 24px;
        box-shadow: 0 22px 45px rgba(8, 32, 50, 0.25);
        border: 1px solid rgba(3, 169, 244, 0.15);
        text-align: center;
        width: 100%;
        max-width: 320px;
    }
    .customer-qr-card .tech-badge {
        display: inline-flex;
        align-items: center;
        padding: 2px 10px;
        border-radius: 12px;
        font-size: 11px;
        background: rgba(3, 169, 244, 0.15);
        color: #046aa7;
        margin-bottom: 8px;
    }
    .customer-qr-card strong {
        font-size: 16px;
        letter-spacing: 0.3px;
    }
    .customer-qr-card .qr-title {
        white-space: nowrap;
        display: inline-block;
        font-weight: 600;
    }
    .customer-qr-card p {
        margin-bottom: 6px;
    }
    .customer-qr-modal .modal-dialog {
        max-width: 460px;
    }
    .customer-qr-modal .modal-body {
        padding: 1.5rem 2rem 1.75rem;
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
    }
    .customer-qr-modal .modal-content {
        background: #fff;
        border-radius: 20px;
        border: none;
        box-shadow: 0 30px 60px rgba(23, 93, 141, 0.25);
    }
    .customer-qr-modal .modal-header {
        border-bottom: none;
        padding-bottom: 0;
    }
    .customer-qr-modal .modal-header .modal-title {
        font-weight: 600;
        color: #0d4e7a;
    }
</style>

<div class="modal fade customer-qr-modal" id="customer_qr_modal" tabindex="-1" role="dialog" aria-labelledby="customerQrModalLabel">
    <div class="modal-dialog modal-dialog-centered customer-qr-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customerQrModalLabel">@lang('lang_v1.customer_qr_code')</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="@lang('messages.close')">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="customer-qr-card mx-auto">
                    <div class="mb-2" id="customer_qr_card_header">
                        <img src="{{ asset('images/boonpharma-logo.png') }}" id="customer_qr_logo" style="max-height:40px; display:block;">
                        <span class="tech-badge">Boon Pharma Reward Card</span>
                        <strong class="qr-title text-dark">Customer QR Code</strong>
                    </div>
                    <img src="" id="customer_qr_image" alt="QR Code" class="img-responsive" style="max-width: 260px; margin:0 auto 10px;">
                    <p id="customer_qr_text" class="text-muted small word-break mb-1"></p>
                    <p id="customer_contact_info" class="text-center small text-dark mb-0"></p>
                </div>
                <div class="mt-3 text-center">
                    <button type="button" class="btn btn-sm btn-outline-secondary" id="customer_qr_download">
                        <i class="fas fa-download"></i> Download Reward Card
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

@include('ledger_discount.create')
@stop

@section('javascript')
<script type="text/javascript">
$(document).ready(function() {
    // Keep current tab in URL
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        if (e.target && e.target.hash) history.replaceState(null, null, e.target.hash);
    });
    var initialHash = window.location.hash;
    if (initialHash && $('.nav-tabs a[href="' + initialHash + '"]').length) {
        $('.nav-tabs a[href="' + initialHash + '"]').tab('show');
    }

    var customerInfo = {!! json_encode([
        'name' => $contact->full_name_with_business,
        'mobile' => $contact->mobile ?? '',
        'address' => strip_tags($contact->contact_address ?? '')
    ]) !!};
    customerInfo.qr_code = '';

    var companyLogoUrl = "{{ session('business.logo') ? asset('uploads/business_logos/' . session('business.logo')) : asset('images/boonpharma-logo.png') }}";

    // Ledger daterange
    $('#ledger_date_range').daterangepicker(dateRangeSettings, function (start, end) {
        $('#ledger_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
    });
    $('#ledger_date_range, #ledger_location').change(get_contact_ledger);
    get_contact_ledger();

    $(document).on('click', '#view_customer_qr_button', function () {
        var qrCode = $(this).data('qr');
        if (!qrCode) {
            return;
        }
        var url = 'https://api.qrserver.com/v1/create-qr-code/?size=280x280&data=' + encodeURIComponent(qrCode);
        $('#customer_qr_image').attr('src', url);
        $('#customer_qr_text').text(qrCode);
        $('#customer_qr_logo').attr('src', companyLogoUrl);
        var formattedAddress = customerInfo.address ? customerInfo.address.replace(/\r?\n/g, '<br>') : '';
        $('#customer_contact_info').html(
            `<strong>${customerInfo.name}</strong><br>${customerInfo.mobile ? '📞 ' + customerInfo.mobile + '<br>' : ''}${formattedAddress}`
        );
        customerInfo.qr_code = qrCode;
        customerInfo.qr_image_url = url;
        $('#customer_qr_modal').modal('show');
    });

    $('#customer_qr_download').on('click', function () {
        if (!customerInfo.qr_code || !customerInfo.qr_image_url) {
            return;
        }
        var downloadWindow = window.open('', '_blank', 'width=450,height=700');
        if (!downloadWindow) {
            alert('@lang("lang_v1.customer_qr_code") - Please allow popups.');
            return;
        }
        var formattedAddress = customerInfo.address ? customerInfo.address.replace(/\r?\n/g, '<br>') : '';
        var cardHtml = `
            <div style="width:360px; font-family: Arial, sans-serif; padding:20px; background:#fff; border:1px solid #ddd; border-radius:12px; text-align:center;">
                <img src="${companyLogoUrl}" alt="logo" style="max-height:40px; margin-bottom:8px;">
                <h3 style="margin:0;font-size:18px;">Boon Pharma Reward Card</h3>
                <small style="color:#555;">Customer QR Code</small>
                <div style="margin:16px 0;">
                    <img src="${customerInfo.qr_image_url?.replace('size=280x280','size=260x260') || customerInfo.qr_image_url}" alt="QR" style="width:260px;height:260px;">
                </div>
                <p style="font-size:12px; color:#888; word-break:break-word;">${customerInfo.qr_code}</p>
                <div style="text-align:left;font-size:13px; color:#222; margin-top:12px;">
                    <strong>${customerInfo.name}</strong><br>
                    ${customerInfo.mobile ? '📞 ' + customerInfo.mobile + '<br>' : ''}
                    <span style="font-size:12px;">${formattedAddress}</span>
                </div>
            </div>
        `;
        downloadWindow.document.write(`<!DOCTYPE html><html><head><title>Boon Pharma Reward Card</title>
            <style>
                body{margin:0;background:#f4f6fb;display:flex;align-items:center;justify-content:center;height:100vh;}
                @media print{body{background:#fff;}}
            </style></head><body>${cardHtml}</body></html>`);
        downloadWindow.document.close();
        downloadWindow.focus();
        downloadWindow.addEventListener('load', function () {
            downloadWindow.print();
        });
    });

    // Reward point table
    rp_log_table = $('#rp_log_table').DataTable({
        processing:true, serverSide:true, fixedHeader:false, aaSorting:[[0,'desc']],
        ajax:'/sells?customer_id={{ $contact->id }}&rewards_only=true',
        columns:[
            {data:'transaction_date', name:'transactions.transaction_date'},
            {data:'invoice_no',       name:'transactions.invoice_no'},
            {data:'rp_earned',        name:'transactions.rp_earned'},
            {data:'rp_redeemed',      name:'transactions.rp_redeemed'},
        ]
    });

    // STOCK REPORT table (no date params)
    var $srTable = $('#supplier_stock_report_table');
    if (!$srTable.length) $srTable = $('#contact_supplier_stock_report_table'); // fallback if your partial uses this id

    if ($srTable.length) {
        window.supplier_stock_report_table = $srTable.DataTable({
            processing:true, serverSide:true, fixedHeader:false,
            ajax:{
                url: "{{ action([\App\Http\Controllers\ContactController::class, 'getSupplierStockReport'], ['supplier_id' => $contact->id]) }}",
                data:function(d){
                    d.location_id = ($('#sr_location_id').length ? $('#sr_location_id').val() : '') || '';
                }
            },
            columns:[
                {data:'product_name',              name:'p.name'},
                {data:'sub_sku',                   name:'v.sub_sku'},
                {data:'purchase_quantity',         name:'purchase_quantity', searchable:false},
                {data:'total_quantity_sold',       name:'total_quantity_sold', searchable:false},
                {data:'total_quantity_transfered', name:'total_quantity_transfered', searchable:false},
                {data:'total_quantity_returned',   name:'total_quantity_returned', searchable:false},
                {data:'current_stock',             name:'current_stock', searchable:false},
                {data:'stock_price',               name:'stock_price', searchable:false}
            ],
            fnDrawCallback:function(){ __currency_convert_recursively($srTable); }
        });

        $(document).on('change', '#sr_location_id', function(){
            if (window.supplier_stock_report_table) window.supplier_stock_report_table.ajax.reload();
        });
    }

    // Misc
    $('#contact_id').change(function(){ if ($(this).val()) window.location = "{{ url('/contacts') }}/" + $(this).val(); });
    $('a[href="#sales_tab"]').on('shown.bs.tab', function(){ if (typeof sell_table !== 'undefined') sell_table.ajax.reload(); });
    $('#discount_date').datetimepicker({ format: moment_date_format + ' ' + moment_time_format, ignoreReadonly:true });
});

// Ledger helpers
$("input.transaction_types, input#show_payments").on('ifChanged', get_contact_ledger);
$(document).on('change', 'input[name="ledger_format"]', get_contact_ledger);
$(document).one('shown.bs.tab', 'a[href="#payments_tab"]', function(){ get_contact_payments(); });
$(document).on('click', '#contact_payments_pagination a', function(e){ e.preventDefault(); get_contact_payments($(this).attr('href')); });

function get_contact_payments(url = null) {
    if (!url) url = "{{action([\App\Http\Controllers\ContactController::class, 'getContactPayments'], [$contact->id])}}";
    $.ajax({
        url: url,
        dataType: 'html',
        success: function(result) {
            $('#contact_payments_div').fadeOut(400, function(){
                $('#contact_payments_div').html(result).fadeIn(400);
            });
        },
    });
}

/* PAYMENTS: make "View" open the same modal as the "Payment For" link, without double-opening. */
$('#payments_tab').on('click', '.btn-modal, .btn-view, .view-payment', function(e){
    e.preventDefault();
    e.stopPropagation();
    e.stopImmediatePropagation();

    var $row = $(this).closest('tr');
    if (!$row.length) return;

    // Find the "Payment For" link in this row
    var $paymentForLink = $row.find('td').filter(function () {
        var txt = $(this).text().trim();
        return /\((Purchase|Sell|Sale|Expense|Transfer|Adjustment)\)/i.test(txt);
    }).find('a[data-href], a[href]').first();

    // Fallback to the button's own data-href
    var href = $paymentForLink.attr('data-href') || $paymentForLink.attr('href') || $(this).data('href');
    var container = $paymentForLink.data('container') || $(this).data('container') || '.view_modal';

    if (!href) return;

    $.ajax({
        url: href,
        dataType: 'html',
        success: function(result){
            $(container).html(result).modal('show');
        }
    });
});

function get_contact_ledger() {
    var start_date = '', end_date = '';
    var transaction_types = $('input.transaction_types:checked').map(function(_,e){return e.value}).toArray();
    var show_payments = $('input#show_payments').is(':checked');
    var location_id = $('#ledger_location').val();

    if($('#ledger_date_range').val()){
        start_date = $('#ledger_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
        end_date   = $('#ledger_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
    }

    var format = $('input[name="ledger_format"]:checked').val();
    $.ajax({
        url: '/contacts/ledger?contact_id={{$contact->id}}',
        data: { start_date, end_date, transaction_types, show_payments, format, location_id },
        dataType:'html',
        success:function(result){
            $('#contact_ledger_div').html(result);
            __currency_convert_recursively($('#contact_ledger_div'));
            $('#ledger_table').DataTable({ searching:false, ordering:false, paging:false, fixedHeader:false, dom:'t' });
        }
    });
}

$(document).on('click', '#send_ledger', function() {
    var start_date = $('#ledger_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
    var end_date   = $('#ledger_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
    var format     = $('input[name="ledger_format"]:checked').val();
    var location_id= $('#ledger_location').val();
    var url = "{{action([\App\Http\Controllers\NotificationController::class, 'getTemplate'], [$contact->id, 'send_ledger'])}}" +
              '?start_date='+start_date+'&end_date='+end_date+'&format='+format+'&location_id='+location_id;
    $.ajax({ url, dataType:'html', success:function(result){ $('.view_modal').html(result).modal('show'); }});
});

$(document).on('click', '#print_ledger_pdf', function() {
    var start_date = $('#ledger_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
    var end_date   = $('#ledger_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
    var format     = $('input[name="ledger_format"]:checked').val();
    var location_id= $('#ledger_location').val();
    var url = $(this).data('href') + '&start_date='+start_date+'&end_date='+end_date+'&format='+format+'&location_id='+location_id;
    window.open(url);
});
</script>

{{-- Sales table JS --}}
@include('sale_pos.partials.sale_table_javascript')

<script src="{{ asset('js/payment.js?v=' . $asset_v) }}"></script>
@if(in_array($contact->type, ['both','supplier']))
    <script src="{{ asset('js/purchase.js?v=' . $asset_v) }}"></script>
@endif

{{-- Documents & notes --}}
@include('documents_and_notes.document_and_note_js')

@if(!empty($contact_view_tabs))
    @foreach($contact_view_tabs as $tabs)
        @foreach ($tabs as $value)
            @if(!empty($value['module_js_path']))
                @include($value['module_js_path'])
            @endif
        @endforeach
    @endforeach
@endif

<script type="text/javascript">
/* ---------- Purchases: daterange + mode (reset on load) + alignment fixes ---------- */
$(document).ready(function () {
  var $dr = $('#purchase_list_filter_date_range');

  $dr.val('');
  $dr.daterangepicker(
    $.extend(true, {}, dateRangeSettings, {
      autoUpdateInput: false,
      locale: { cancelLabel: 'Clear' }
    }),
    function (start, end) {
      $dr.val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
      if (typeof purchase_table !== 'undefined') purchase_table.ajax.reload();
    }
  );
  $dr.on('cancel.daterangepicker', function () {
    $(this).val('');
    if (typeof purchase_table !== 'undefined') purchase_table.ajax.reload();
  });

  $('#purchase_mode_filter').select2();

  $(document).on('preInit.dt', '#purchase_table', function () {
    if (typeof purchase_table !== 'undefined' && purchase_table.state && purchase_table.state.clear) {
      purchase_table.state.clear();
    }
  });

  $(document).on('preXhr.dt', '#purchase_table', function (e, settings, data) {
    data.purchase_mode = $('#purchase_mode_filter').val() || '';
    if (!$dr.val()) {
      data.start_date = '';
      data.end_date = '';
    }
  });

  $(document).on('change', '#purchase_mode_filter', function () {
    if (typeof purchase_table !== 'undefined') purchase_table.ajax.reload();
  });

  $(document).on('init.dt draw.dt', '#purchase_table', function () {
    if (typeof purchase_table !== 'undefined') {
      purchase_table.columns.adjust();
      if (purchase_table.responsive && purchase_table.responsive.recalc) {
        purchase_table.responsive.recalc();
      }
    }
  });

  $('a[href="#purchases_tab"]').on('shown.bs.tab', function () {
    $.fn.dataTable.tables({ visible: true, api: true }).columns.adjust();
  });

  $(window).on('resize', function () {
    $.fn.dataTable.tables({ visible: true, api: true }).columns.adjust();
  });

  $(document).on('collapsed.pushMenu expanded.pushMenu', function () {
    setTimeout(function () {
      $.fn.dataTable.tables({ visible: true, api: true }).columns.adjust();
    }, 300);
  });
});
</script>

@include('sale_pos.partials.subscriptions_table_javascript', ['contact_id' => $contact->id])

{{-- Hard remove Pay Due Amount + Add Discount even if injected later (AJAX/modals) --}}
<script>
$(function () {
  function removeRestrictedButtons () {
    const sel = [
      'a.pay_purchase_due',
      '.pay_purchase_due',
      '#add_discount',
      '#add_ledger_discount',
      '#add_ledger_discount_btn',
      '.btn-add-discount',
      '.contact-add-discount',
      '.tw-add-discount'
    ].join(',');

    $(sel).each(function () {
      $(this).off().remove();
    });

    // Safety: also remove by exact label, just in case selectors differ
    $('a,button').filter(function () {
      const t = $(this).text().trim().toLowerCase();
      return t === 'pay due amount' || t === 'add discount';
    }).each(function () { $(this).off().remove(); });
  }

  removeRestrictedButtons();
  try {
    new MutationObserver(removeRestrictedButtons)
      .observe(document.body, { childList: true, subtree: true });
  } catch (e) {}
});
</script>

@endsection
